/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.order;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OrderStatusEnum {
    CREATED(0, "\u5df2\u4e0b\u5355"),
    UNSHIPPED(1, "\u5f85\u53d1\u8d27"),
    SHIPPED(2, "\u5f85\u6536\u8d27"),
    COMPLETED(3, "\u5df2\u5b8c\u6210"),
    CANCELED(4, "\u5df2\u53d6\u6d88");

    private final Integer code;
    private final String desc;
    private static final Map<Integer, OrderStatusEnum> ENUM_MAP;

    public static OrderStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getLogName() {
        return this.desc + "[" + this.code + "]";
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private OrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(OrderStatusEnum.values()).collect(Collectors.toMap(OrderStatusEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

