package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.SettlementCardSecretBatchDetailDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.SettlementCardSecretBatchLockOrUnlockParam;

import java.util.List;

/**
 * 结算单卡密批次明细
 * @author kjj mybatis generator 
 * @date 2025-11-14
 */
@AdvancedFeignClient
public interface RemoteSettlementCardSecretBatchDetailService {

    /**
     * 根据结算单ID查询
     * @param settlementId 结算单ID
     * @return 结算单卡密批次明细
     */
    List<SettlementCardSecretBatchDetailDto> selectBySettlementId(Long settlementId);
    
    /**
     * 批量插入
     * @param list 批量插入数据
     * @return 执行结果
     */
    int batchInsert(List<SettlementCardSecretBatchDetailDto> list);

    /**
     * 批量锁定或解锁卡密明细
     * @param lockOrUnlockParamList 锁定或解锁参数集合
     * @return 执行结果
     */
    boolean batchLockOrUnlock(List<SettlementCardSecretBatchLockOrUnlockParam> lockOrUnlockParamList);
}