package cn.com.duiba.quanyi.goods.service.api.dto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * SPU表
 *
 * @author kjj mybatis generator
 * @date 2023-11-20
 */
@Data
public class SpuEsDto implements Serializable {

    private static final long serialVersionUID = 17004797933864112L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 分类ID
     */
    private Long goodsClassId;

    /**
     * 商品类型，1-实物，2-微信立减金
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 商品主图链接，多张图用英文 逗号 分割
     */
    private String mainImgs;

    /**
     * 商品状态：0-停用，1-启用
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuStatusEnum
     */
    private Integer spuStatus;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 是否已删除：0-未删除，1-已删除
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;
}