package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretCouponDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretCouponBatchQueryParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretCouponQueryParam;

/**
 * CardSecretCouponRemoteService
 * @author fumingkun
 */
@AdvancedFeignClient
public interface RemoteCardSecretCouponService {

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    long selectCount(CardSecretCouponQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectPage(CardSecretCouponQueryParam queryParam);

    /**
     * 根据卡密批次IDh和劵码状态查询
     *
     * @param cardSecretBatchId 卡密批次ID
     * @param codeStatus        劵码状态
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectByCardSecretBatchIdAndStatus(Long cardSecretBatchId, Integer codeStatus);

    /**
     * 根据任务ID查询
     *
     * @param taskId 任务ID
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectByTaskId(Long taskId);

    /**
     * 删除未使用的卡密券
     * 条件：cardSecretBatchId
     */
    int deleteByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 获取卡密券锁
     *
     * @param cardSecretBatchId 卡密券批次ID
     * @return true/false
     */
    boolean getRedisLockByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 根据code、link、account集合批量查询
     * 数量不能超过500
     *
     * @param queryParam 批量查询参数
     * @return A List Of CardSecretCouponDto
     */
    List<CardSecretCouponDto> selectByBatchQuery(CardSecretCouponBatchQueryParam queryParam);

    /**
     * 根据批次ID集合和使用状态批量查询
     *
     * @param batchIds     批次ID集合
     * @param couponStatus 使用状态（0-未使用，1-已使用）
     * @return 卡密券列表
     */
    List<CardSecretCouponDto> selectByBatchIdsAndStatus(List<Long> batchIds, Integer couponStatus);

}
