package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.jd.JdWaiMaiZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.jd.JdWaiMaiZcSmsReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.jd.JdWaiMaiZcOrderResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.jd.JdWaiMaiZcSmsCodeResult;

/**
 * 京东外卖订单处理器远程服务接口
 *
 * @author yangyukang
 * @since 2024/12/19
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorJdWaiMaiService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<JdWaiMaiZcOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    JdWaiMaiZcOrderResult findOrderResult(String customerOrderNo);

    /**
     * 京东外卖发送验证码
     * @param req 请求参数 
     * @return 发送结果
     */
    JdWaiMaiZcSmsCodeResult jdWaiMaiSmsSend(JdWaiMaiZcSmsReq req);
} 