package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 操作日志，操作类型
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyLogOperateType {

    CREATE(1, "创建"),
    UPDATE(2, "更新"),
    VALIDATE(3, "生效"),
    INVALIDATE(4, "失效");

    public int    value;
    public String desc;

    RatelimitPolicyLogOperateType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitPolicyLogOperateType get(int value) {
        for (RatelimitPolicyLogOperateType item : RatelimitPolicyLogOperateType.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
