package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 触发限流时，做的操作
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyOperation {

    IDENTIFYING_GESTURE(1, "手势验证"),
    BUSY_PAGE(2, "跳转繁忙页面");

    public int    value;
    public String desc;

    RatelimitPolicyOperation(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitPolicyOperation get(int value) {
        for (RatelimitPolicyOperation item : RatelimitPolicyOperation.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
