package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.bean.PagerResponse;
import cn.com.duiba.ratelimit.service.api.dto.HostOwnershipDto;
import cn.com.duiba.ratelimit.service.api.dto.HostOwnershipPageRequestDto;
import cn.com.duiba.ratelimit.service.api.dto.HostOwnershipPageResponseDto;
import cn.com.duiba.ratelimit.service.api.dto.HostOwnershipSaveDto;

import java.util.List;

/**
 * Created by guoyanfei .
 * 2018/8/16 .
 */
@AdvancedFeignClient
public interface RemoteHostOwnershipBackendService {

    /**
     * 域名所有权证明的分页列表
     * @param pagerRequest
     * @return
     */
    PagerResponse<HostOwnershipPageResponseDto> page(HostOwnershipPageRequestDto pagerRequest);

    /**
     * 保存
     * @param dto
     * @return
     */
    Boolean save(HostOwnershipSaveDto dto);

    /**
     * 立即失效操作
     * @param id
     * @return
     */
    Boolean invalidate(Long id);

    /**
     * 通过域名数组获取已经存在的记录列表
     * @param hostNames
     * @param fileName
     * @return
     */
    List<HostOwnershipDto> getExistFiles(List<String> hostNames, String fileName);

}
