package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.bean.PagerRequest;
import cn.com.duiba.ratelimit.service.api.bean.PagerResponse;
import cn.com.duiba.ratelimit.service.api.dto.TimeoutDto;
import cn.com.duiba.ratelimit.service.api.dto.TimeoutPageRequestDto;

import java.util.List;

/**
 * APP 超时配置
 * @author houwen
 */
@AdvancedFeignClient
public interface RemoteTimeoutService {

    /**
     * 查询所有APP 网关超时配置
     * @return
     */
    public List<TimeoutDto> findAll();

    /**
     * 添加超时熔断配置
     * @param entity
     */
    public void insert(TimeoutDto entity);

    /**
     * 修改超时熔断配置
     * @param entity
     * @return
     */
    public int update(TimeoutDto entity);

    /**
     * 启用禁用超时熔断配置
     * @param id
     * @param enable
     * @return
     */
    public int updateEnable(Long id, Boolean enable);

    /**
     * 删除
     * @param id
     * @return
     */
    public int delete(Long id);

    /**
     * 分页查询
     * @param request
     * @return
     */
    public PagerResponse<TimeoutDto> findByPage(TimeoutPageRequestDto request);

}
