package cn.com.duiba.scrm.center.api.remoteservice.menu;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.menu.ScCorpMenuDto;
import cn.com.duiba.scrm.center.api.remoteservice.menu.param.CreateScCorpMenusParam;

import java.util.List;

/**
* 企业菜单权限表 RemoteService
* @author xiaotian
* 2021-7-14 14:21:56
*/
@AdvancedFeignClient
public interface RemoteScCorpMenuService {
    /**
    * 新增记录
    */
	Boolean save(ScCorpMenuDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteByScCorpMenuId(Long scCorpMenuId);
    /**
    * 根据id更新
    */
    Boolean updateByScCorpMenuId(ScCorpMenuDto dto);
    /**
    * 根据id获取
    */
    ScCorpMenuDto getByScCorpMenuId(Long scCorpMenuId);



    /**
     * 创建企业菜单权限
     * @param param 创建企业菜单权限的参数
     * @return
     */
    Boolean createScCorpMenus(CreateScCorpMenusParam param) throws BizException;


}
