package cn.com.duiba.scrm.center.api.remoteservice.role;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.role.ScRoleDto;

import java.util.List;

/**
* 角色信息表 RemoteService
* @author xiaotian
* 2021-7-14 14:22:25
*/
@AdvancedFeignClient
public interface RemoteScRoleService {
    /**
    * 新增记录
    */
	Boolean save(ScRoleDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteByScRoleId(Long scRoleId);
    /**
    * 根据id更新
    */
    Boolean updateByScRoleId(ScRoleDto dto);
    /**
    * 根据id获取
    */
    ScRoleDto getByScRoleId(Long scRoleId);

    /**
     * 根据用户id获取角色信息
     * @param scUserId
     * @return
     */
    List<ScRoleDto> getByScUserId(Long scUserId);


}
