package cn.com.duiba.scrm.center.api.enums;

import java.util.Objects;

/**
 * 角色等级
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/7/21 15:17
 */
@SuppressWarnings("all")
public enum RoleLevelEnum {
    ROOT_MANAGER(0, 0, "高级管理员", DataScope.ALL),
    MANAGER(1, 1, "普通管理员", DataScope.ALL),
    DEPARTMENT_MANAGER(2, 2, "部门管理员", DataScope.DEPARTMENT),
    EMPLOYEE(3, 2, "一线员工", DataScope.ONLY_SELF),
    ;


    private final Integer level;
    private final Integer sort;
    private final String name;
    /**
     * 角色的数据权限
     * // fixme 后续细分sc_role_user.id上
     */
    private final DataScope dataScope;

    RoleLevelEnum(Integer level, Integer sort, String name, DataScope dataScope) {
        this.level = level;
        this.sort = sort;
        this.name = name;
        this.dataScope = dataScope;
    }

    public Integer getLevel() {
        return level;
    }

    public Integer getSort() {
        return sort;
    }

    public String getName() {
        return name;
    }

    public static RoleLevelEnum getEnum(Integer level) {
        for (RoleLevelEnum levelEnum : values()) {
            if (Objects.equals(levelEnum.getLevel(), level)) {
                return levelEnum;
            }
        }
        return null;
    }

    public DataScope getDataScope() {
        return dataScope;
    }
}
