package cn.com.duiba.scrm.center.api.param;

import cn.com.duiba.scrm.common.param.ScrmPageQuery;

import java.util.ArrayList;
import java.util.List;

/**
 * 所有操作基类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/7/24 11:05
 */
public class BaseOperateParam extends ScrmPageQuery {
    private static final long serialVersionUID = -720336006336083004L;

    /**
     * 操作人
     * =sc_user.id
     */
    private Long actorId;
    /**
     * 企业
     * =sc_corp_account.id
     */
    private Long scCorpId;

    /**
     * 数据权限限定的范围
     * 成员，直接join
     */
    private Long       limitWechatUserId;
    /**
     * 部门，需要join表
     */
    private List<Long> limitDeptIdList = new ArrayList<>();


    public Long getActorId() {
        return actorId;
    }

    public void setActorId(Long actorId) {
        this.actorId = actorId;
    }

    public Long getScCorpId() {
        return scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Long getLimitWechatUserId() {
        return limitWechatUserId;
    }

    public void setLimitWechatUserId(Long limitWechatUserId) {
        this.limitWechatUserId = limitWechatUserId;
    }

    public List<Long> getLimitDeptIdList() {
        return limitDeptIdList;
    }

    public void setLimitDeptIdList(List<Long> limitDeptIdList) {
        this.limitDeptIdList = limitDeptIdList;
    }
}
