package cn.com.duiba.scrm.center.api.remoteservice.groupmsg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgDto;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
* 客户群发 RemoteService
* @author xiaotian
* 2021-7-30 13:39:35
*/
@AdvancedFeignClient
public interface RemoteGroupMsgService {
    /**
    * 新增记录
    */
	Long save(GroupMsgDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(GroupMsgDto dto);
    /**
    * 根据id获取
    */
    GroupMsgDto getById(Long id);

    /**
     * 保存群发、群群发任务
     */
    ScrmResult<Long> saveTask(GroupMsgQueryParam groupMsgParam);
}
