package cn.com.duiba.scrm.center.api.dto.material;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 素材表
 * 2021-7-24 10:32:28
 */
@Data
public class MaterialDto implements Serializable {

    /**
     * 关联业务id
     */
    private Long bizId;

    /**
     * 业务类型1、个人活码，2、欢迎语，3 群发
     */
    private Integer bizType;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 删除标记 0:正常 1:删除
     */
    private Integer delFlag;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 描述
     */
    private String materialDesc;

    /**
     * 名称
     */
    private String materialName;

    /**
     * 图片
     */
    private String materialPic;

    /**
     * 文本
     */
    private String materialText;

    /**
     * 类型1文字，2图片，3链接
     */
    private Integer materialType;


    /**
     * 企微信息表id
     */
    private Long scCorpId;


    public MaterialDto() {

    }

    /**
     * 转化基本素材
     *
     * @param baseMaterialDto
     */
    public MaterialDto(BaseMaterialDto baseMaterialDto) {
        this.materialType = baseMaterialDto.getMaterialType();
        this.materialText = baseMaterialDto.getMaterialText();

        this.materialPic = baseMaterialDto.getMaterialPic();

        this.materialName = baseMaterialDto.getMaterialName();
        this.materialDesc = baseMaterialDto.getMaterialDesc();
        this.id = baseMaterialDto.getId();
    }
}

