package cn.com.duiba.scrm.center.api.remoteservice.groupmsg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgSendResultDto;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgTaskSendResultQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
* 群发成员执行结果 RemoteService
* @author xiaotian
* 2021-7-30 13:39:38
*/
@AdvancedFeignClient
public interface RemoteGroupMsgSendResultService {
    /**
    * 新增记录
    */
	Boolean save(GroupMsgSendResultDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(GroupMsgSendResultDto dto);
    /**
    * 根据id获取
    */
    GroupMsgSendResultDto getById(Long id);

    /**
     * 根据查询条件统计数据
     * @param groupMsgTaskSendResultQueryParam ScrmResult<Long>
     * @return ScrmResult<Long>
     */
    ScrmResult<Long> countByParam(GroupMsgTaskSendResultQueryParam groupMsgTaskSendResultQueryParam);
}
