package cn.com.duiba.scrm.center.api.remoteservice.suite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.param.corp.ComponentSuiteAuthParam;
import cn.com.duiba.scrm.center.api.param.suite.SaveTicketParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import javax.annotation.Nullable;

/**
 * @author wangxukai
 * @description 应用授权相关接口
 * @date ：Created in 2021/7/12
 */
@AdvancedFeignClient
public interface RemoteScSuiteAuthSerivce {

    /**
     * 获取第三方应用授权链接
     * @param oaId
     * @return
     */
    @Nullable
    ScrmResult<String> buildSuitePreAuthUrl(Long oaId);

    /**
     * 保存ticket。
     * @param param
     */
    ScrmResult saveTicket(SaveTicketParam param);


    /**
     * 保存获取企微信息
     * @param param
     * @return
     */
    ScrmResult<Integer> saveAuthCorpWxInfo(ComponentSuiteAuthParam param);

}
