package cn.com.duiba.scrm.center.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.customer.DelCustomerDto;
import cn.com.duiba.scrm.center.api.param.delCustomer.DelCustomerPageParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
 * 删除流失客户提醒 RemoteService
 *
 * @author xiaotian
 * 2021-7-30 17:37:32
 */
@AdvancedFeignClient
public interface RemoteDelCustomerService {
    /**
     * 新增记录
     */
    Boolean save(DelCustomerDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(DelCustomerDto dto);

    /**
     * 根据id获取
     */
    DelCustomerDto getById(Long id);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    ScrmResult<ScrmPageResult<DelCustomerDto>> pageQuery(DelCustomerPageParam param);


}
