package cn.com.duiba.scrm.center.api.remoteservice.dynamic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.dynamic.DynamicDto;
import cn.com.duiba.scrm.center.api.param.dynamic.DynamicPageQuery;
import cn.com.duiba.scrm.common.result.ScrmPageResult;

/**
* 企业微信动态表 RemoteService
* @author xiaotian
* 2021-7-27 13:59:30
*/
@AdvancedFeignClient
public interface RemoteDynamicService {
    /**
    * 新增记录
    */
	Boolean save(DynamicDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(DynamicDto dto);
    /**
    * 根据id获取
    */
    DynamicDto getById(Long id);

    /**
     * 动态筛选
     * @param dynamicPageQuery
     * @return
     */
    ScrmPageResult<DynamicDto>  query(DynamicPageQuery dynamicPageQuery);
}
