package cn.com.duiba.scrm.center.api.remoteservice.wechatSync;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.user.UserDto;
import cn.com.duiba.scrm.center.api.dto.user.WechatUserDto;
import cn.com.duiba.scrm.center.api.enums.AddCustomerTypeEnum;
import cn.com.duiba.scrm.center.api.enums.LoseCustomerStatus;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.user.WeUserResult;

/**
 * @author wangxukai
 * @description 应用授权相关接口
 * @date ：Created in 2021/7/12
 */
@AdvancedFeignClient
public interface RemoteWehatSyncSerivce {

    /*------------------------------全量同步企业信息----------------------------------*/

    /**
     * 同步企业信息（全量）
     *
     * @param scCorpId
     * @returnRedisKeyFactory
     */
    ScrmResult<Boolean> syncCompany(Long scCorpId);

    /**
     * 同步企业部门（全量）
     *
     * @param scCorpId
     * @returnRedisKeyFactory
     */
    ScrmResult<Boolean> syncDepartment(Long scCorpId);

    /**
     * 同步成员（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncUser(Long scCorpId);


    /**
     * 同步客户（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncCustomer(Long scCorpId);


    /**
     * 同步群聊（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncChatGroup(Long scCorpId);


    /**
     * 同步标签（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncAllTag(Long scCorpId);


    /*------------------------------全量同步企业信息----------------------------------*/


    /*------------------------------同步单个成员信息----------------------------------*/

    /**
     * 更新成员
     *
     * @param scCorpId
     * @param weUserResult
     * @param wechatUserDto
     */
    void updateUser(Long scCorpId, WeUserResult weUserResult, WechatUserDto wechatUserDto, String newUserId);


    /**
     * 新增成员
     *
     * @param scCorpId
     * @param weUserResult
     */
    void saveWechatUser(Long scCorpId, WeUserResult weUserResult);


    /**
     * 删除用户
     *
     * @param scCorpId
     * @param wxchatUserId
     * @return
     */
    boolean deleteUser(Long scCorpId, Long wxchatUserId);
    /*------------------------------同步单个成员信息----------------------------------*/

    /*------------------------------同步单个客户信息----------------------------------*/

    /**
     * @param scCorpId
     * @param wechatUserDto
     * @param customerUserId
     * @return
     */
    boolean saveOrUpdateCustomer(Long scCorpId, WechatUserDto wechatUserDto, String customerUserId, AddCustomerTypeEnum addCustomerTypeEnum);


    /**
     * 员工删除客户
     *
     * @param scCorpId
     * @param wechatUserDto
     * @param customerUserId
     * @return
     */
    boolean delCustomer(Long scCorpId, WechatUserDto wechatUserDto, String customerUserId, LoseCustomerStatus loseCustomerStatus);

    /*------------------------------同步单个客户信息----------------------------------*/


    /*------------------------------同步群聊信息----------------------------------*/

    /**
     * 解散群聊
     *
     * @param scCorpId
     * @param chatId
     * @return
     */
    boolean dissolveChatGroup(Long scCorpId, String chatId);


    /**
     * 同步单个群聊
     *
     * @param scCorpId
     * @param chatId
     * @return
     */
    boolean syncSingleGroup(Long scCorpId, String chatId);

    /*------------------------------同步群聊信息----------------------------------*/


    /*------------------------------同步标签信息----------------------------------*/

    /**
     * 删除标签组
     * @param tagGroupId
     * @return
     */
    boolean delTagGroup(Long scCorpId,String tagGroupId);

    /**
     * 删除标签
     * @param tagId
     * @return
     */
    boolean delTag(Long scCorpId,String tagId);


    /**
     * 同步标签组
     * @param tagGroupId
     * @return
     */
    boolean syncTagGroup(Long scCorpId,String tagGroupId);

    /**
     * 同步标签
     * @param tagId
     * @return
     */
    boolean syncTag(Long scCorpId,String tagId);

    /*------------------------------同步标签信息----------------------------------*/


    /*-----------------------------群发信息----------------------------------*/


    /**
     * 通过群发任务Id，同步群发信息
     * @param taskId
     * @return
     */
    boolean syncGroupMsg(Long taskId);

    /*------------------------------群发信息----------------------------------*/
}
