package cn.com.duiba.scrm.center.api.remoteservice.department;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.department.DepartmentDto;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
* 企业微信组织架构相关 RemoteService
* @author xiaotian
* 2021-7-17 10:32:42
*/
@AdvancedFeignClient
public interface RemoteDepartmentService {
    /**
    * 新增记录
    */
	Boolean save(DepartmentDto dto);

    /**
    * 根据id更新
    */
    Boolean updateById(DepartmentDto dto);
    /**
    * 根据id获取
    */
    DepartmentDto getById(Long id);


    /**
     * 根据企业Id和微信部门id获取部门对象
     * @param scCorpId
     * @param deptId
     * @return
     */
    DepartmentDto getByCorpIdAndDeptId(Long scCorpId,Long deptId);

    /**
     * 根据企业Id和部门主键id列表获取部门对象列表
     * @param scCorpId
     * @param ids
     * @return
     */
    List<DepartmentDto> getByCorpIdAndIdList(Long scCorpId,List<Long> ids);

    /**
     * 根据企业ID获取部门列表
     * @param scCorpId
     * @return
     */
    List<DepartmentDto> getListByScCorpId(Long scCorpId);

    /**
     * 根据父级部门id获取子部门列表
     *
     * @param scCorpId
     * @param fatherDeptId
     * @return
     */
    List<DepartmentDto> queryChildDepartment(Long scCorpId, Long fatherDeptId);


    /**
     * 获取根节点
     *
     * @param scCorpId
     * @return
     */
    DepartmentDto getRootDept(Long scCorpId);

    /**
     * 根据企业ID获取部门列表
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<List<DepartmentDto>> getListByScCorpIdAndDeptIds(Long scCorpId, List<Long> deptIds);


}
