package cn.com.duiba.scrm.center.api.remoteservice.department;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.department.WechatUserDeptRelDto;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
* 部门员工关联表 RemoteService
* @author xiaotian
* 2021-7-17 10:35:01
*/
@AdvancedFeignClient
public interface RemoteWechatUserDeptRelService {
    /**
    * 新增记录
    */
	Boolean save(WechatUserDeptRelDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(WechatUserDeptRelDto dto);
    /**
    * 根据id获取
    */
    WechatUserDeptRelDto getById(Long id);
    /**
     * 根据企业Id和企微用户Id（sc_wechat_id.id）获取用户
     * @param corpId
     * @param wechatUserId
     * @return
     */
    List<WechatUserDeptRelDto> getListByCorpIdAndUserId(Long corpId, Long wechatUserId);


    /**
     * 根据企业Id和企微用户Id（sc_wechat_id.id）获取用户
     *
     * @param corpId
     * @param wechatUserIds
     * @return
     */
    List<WechatUserDeptRelDto> getListByCorpIdAndUserIdList(Long corpId, List<Long> wechatUserIds);

    /**
     * 根据企业id和部门id（sc_department.id)获取用户
     *
     * @param corpId
     * @param deptIdList
     * @return
     */
    ScrmResult<List<WechatUserDeptRelDto>> getListByCorpIdAndDeptIdList(Long corpId, List<Long> deptIdList);
}
