package cn.com.duiba.scrm.center.api.remoteservice.material;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.material.MaterialDto;
import cn.com.duiba.scrm.center.api.param.material.MaterialPageQueryParam;
import cn.com.duiba.scrm.center.api.param.material.MaterialQueryParam;
import cn.com.duiba.scrm.center.api.param.material.MaterialSaveQueryParam;
import cn.com.duiba.scrm.center.api.param.material.WelcomeMsgPageQueryParam;
import cn.com.duiba.scrm.common.enums.db.BizTypeEnum;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 素材表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 10:32:28
 */
@AdvancedFeignClient
public interface RemoteMaterialService {
    /**
     * 新增记录
     */
    Long save(MaterialDto dto);

    Boolean saveBatch(List<MaterialDto> dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(MaterialDto dto);

    /**
     * 根据id获取
     */
    MaterialDto getById(Long id);

    /**
     * 获取素材列表
     *
     * @param dto
     * @return
     */
    ScrmResult<List<MaterialDto>> getByDto(MaterialDto dto);

    ScrmResult<ScrmPageResult<MaterialDto>> getWelcomeMsgPageVos(WelcomeMsgPageQueryParam query);

    ScrmResult<Integer> delByBizId(BizTypeEnum type, Long bizId);


    ScrmResult<List<MaterialDto>> getByBizIds(BizTypeEnum type, List<Long> bizId);

    ScrmResult<Boolean> saveBatchMaterials(List<MaterialSaveQueryParam> materials);

    ScrmResult<List<MaterialDto>> getByBizIdsAuth(MaterialQueryParam materialQueryParam);
    /**
     * 获取素材根据条件
     * @param query
     * @return
     */
    ScrmResult<ScrmPageResult<MaterialDto>>  getMaterialByCondition(MaterialPageQueryParam query);

    ScrmResult<List<MaterialDto>> getByIdsAuth(List<Long> ids);

}
