package cn.com.duiba.scrm.center.api.remoteservice.shorcut;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.shorcut.ShortcutPhraseGroupDto;
import cn.com.duiba.scrm.center.api.param.BaseOperateParam;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.center.api.param.phrase.*;
import java.util.List;

/**
 * 话术分组表 RemoteService
 *
 * @author xiaotian
 * 2021-7-31 19:54:16
 */
@AdvancedFeignClient
public interface RemoteShortcutPhraseGroupService {
    /**
     * 新增记录
     * @param param
     */
    ScrmResult<Boolean> save(ShortcutPhraseGroupSaveParam param);

    /**
     * 根据id删除
     */
    ScrmResult<Boolean> deleteById(ShortcutPhraseGroupDeleteParam param);

    /**
     * 根据id更新
     */
    ScrmResult<Boolean> updateById(ShortcutPhraseGroupUpdateParam param);

    /**
     * 根据id获取
     */
    ScrmResult<ShortcutPhraseGroupDto> getById(ShortcutPhraseGroupGetParam param);

    /**
     * 根据企业id获取话术分组,有效的
     */
    ScrmResult<List<ShortcutPhraseGroupDto>> queryByCorpId(BaseOperateParam param);

    /**
     * 条件统计
     */
    ScrmResult<Long> queryCount(ShortcutPhraseGroupGetParam param);

}
