package cn.com.duiba.scrm.center.api.param.customer;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/7/26 12:53
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerNoUnionQueryParam extends BaseOperateParam {

    /**
     * 性别 0 全部性别，1 仅男性粉丝，2 仅女性粉丝，3 未知性别
     */
    private Integer genderType;

    /**
     * 所在群聊
     */
    private List<String> groupIds;

    /**
     * 添加时间-开始日期，格式 yyyy-MM-dd
     */
    private String start;

    /**
     * 添加时间-结束日期，格式 yyyy-MM-dd
     */
    private String end;

    /**
     * 企微客户标签
     */
    private List<Long> tagIds;


    public List<String> getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public List<Long> getTagIds() {
        return tagIds;
    }

    public void setTagIds(List<Long> tagIds) {
        this.tagIds = tagIds;
    }

    public Integer getGenderType() {
        return genderType;
    }

    public void setGenderType(Integer genderType) {
        this.genderType = genderType;
    }


    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

}
