package cn.com.duiba.scrm.center.api.remoteservice.groupmsg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgDto;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
* 客户群发 RemoteService
* @author xiaotian
* 2021-7-30 13:39:35
*/
@AdvancedFeignClient
public interface RemoteGroupMsgService {

    /**
     * 保存群发、群群发任务
     */
    ScrmResult<Long> saveTask(GroupMsgQueryParam groupMsgParam);

    /**
     * 修改群发、群群发任务
     */
    ScrmResult<Boolean> updateTaskById(GroupMsgQueryParam groupMsgParam);

    /**
     * 根据id查询
     */
    ScrmResult<GroupMsgDto> getByIdAuth(GroupMsgQueryParam groupMsgParam);

    /**
     * 分页查询
     */
    ScrmResult<ScrmPageResult<GroupMsgDto>> pageQueryAuth(GroupMsgQueryParam groupMsgParam);
}
