package cn.com.duiba.scrm.center.api.remoteservice.suite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.corp.ScCorpAccountDto;
import cn.com.duiba.scrm.center.api.dto.suite.ScSuiteAccountDto;
import cn.com.duiba.scrm.center.api.param.suite.QuerySuiteByIdsParam;
import cn.com.duiba.scrm.center.api.param.suite.QuerySuitePageParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
* 应用信息配置表 RemoteService
* @author xiaotian
* 2021-7-14 11:08:00
*/
@AdvancedFeignClient
public interface RemoteScSuiteAccountService {
    /**
    * 新增记录
    */
	Boolean save(ScSuiteAccountDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(ScSuiteAccountDto dto);
    /**
    * 根据id获取
    */
    ScSuiteAccountDto getById(Long id);

    /**
     * 根据suiteId获取
     */
    ScrmResult<ScSuiteAccountDto> getBySuiteId(String suiteId);

    /**
     * 筛选列表
     * @param queryPageParam
     * @return
     */
    ScrmResult<List<ScSuiteAccountDto>> queryPageList(QuerySuitePageParam queryPageParam);

    ScrmResult<Integer> countQueryPageList(QuerySuitePageParam queryPageParam);


    /**
     * 查询应用列表
     * @param param
     * @return
     */
    ScrmResult<List<ScSuiteAccountDto>> getByIds(QuerySuiteByIdsParam param);
}
