package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagGroupDetailDto;
import cn.com.duiba.scrm.center.api.dto.tag.TagGroupDto;
import cn.com.duiba.scrm.center.api.param.TagGroupQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 标签组 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 19:23:52
 */
@AdvancedFeignClient
public interface RemoteTagGroupService {
    /**
     * 新增记录
     */
    Boolean save(TagGroupDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TagGroupDto dto);

    /**
     * 根据id获取
     */
    TagGroupDto getById(Long id);


    ScrmResult<ScrmPageResult<TagGroupDetailDto>> queryPage(TagGroupQueryParam queryParam);


    ScrmResult<List<TagGroupDto>> getByIds(Long scCorpId,List<String> groupIds);
}
