package cn.com.duiba.scrm.center.api.dto.chatgroup;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.center.api.enums.ChatGroupStatusEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.CustomerGroupDetailResult;

import java.util.Date;

/**
 * 企业微信群
 * 2021-7-24 13:52:14
 */
public class ChatGroupDto implements BaseDto {
    private static final long serialVersionUID = 3888190080871926419L;

    /**
     * 主键id，自增
     */
    private Long id;

    /**
     * id
     */
    private String chatId;

    /**
     * 群名
     */
    private String groupName;

    /**
     * 群公告
     */
    private String groupNotice;

    /**
     * 群主userId
     */
    private String groupOwner;

    /**
     * 群主:sc_user.id
     */
    private Long scUserId;

    /**
     * -1:不存在 0 - 正常;1 - 跟进人离职;2 - 离职继承中;3 - 离职继承完成
     * {@link ChatGroupStatusEnum}
     */
    private Integer groupStatus;

    /**
     * 企业id
     */
    private Long scCorpId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 删除状态 0：未删除 1：已删除
     */
    private Integer delFlag;


    public static ChatGroupDto convert(CustomerGroupDetailResult.GroupChat groupChat, Integer status) {
        ChatGroupDto chatGroupDto = new ChatGroupDto();
        chatGroupDto.setChatId(groupChat.getChatId());
        chatGroupDto.setGroupName(groupChat.getName());
        chatGroupDto.setGroupNotice(groupChat.getNotice());
        chatGroupDto.setGroupOwner(groupChat.getOwner());
        chatGroupDto.setGroupStatus(status);
        chatGroupDto.setGmtCreate(new Date(groupChat.getCreateTime()*1000));
        return chatGroupDto;
    }


    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChatId() {
        return chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupNotice() {
        return groupNotice;
    }

    public void setGroupNotice(String groupNotice) {
        this.groupNotice = groupNotice;
    }

    public String getGroupOwner() {
        return groupOwner;
    }

    public void setGroupOwner(String groupOwner) {
        this.groupOwner = groupOwner;
    }

    public Long getScUserId() {
        return scUserId;
    }

    public void setScUserId(Long scUserId) {
        this.scUserId = scUserId;
    }

    public Integer getGroupStatus() {
        return groupStatus;
    }

    public void setGroupStatus(Integer groupStatus) {
        this.groupStatus = groupStatus;
    }

    public Long getScCorpId() {
        return scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

