package cn.com.duiba.scrm.center.api.remoteservice.role;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.role.RoleDto;
import cn.com.duiba.scrm.center.api.dto.role.UserRoleDetailDto;
import cn.com.duiba.scrm.center.api.param.role.BandUserRoleDeptParam;
import cn.com.duiba.scrm.center.api.param.role.BandUserRoleParam;
import cn.com.duiba.scrm.center.api.param.role.TransferCreatorParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 角色信息表 RemoteService
 *
 * @author xiaotian
 * 2021-7-16 22:47:19
 */
@AdvancedFeignClient
public interface RemoteRoleService {
    /**
     * 获取用户的角色
     *
     * @param scWechatUserId
     * @return
     */
    List<RoleDto> getRolesByScWechatUserId(Long scWechatUserId);

    /**
     * 获取企业的角色列表
     */
    List<RoleDto> getRolesByScCorpId(Long scCorpId);

    /**
     * 转移创建者
     */
    ScrmResult<Boolean> transferCreator(TransferCreatorParam param);

    /**
     * 绑定指定员工到指定角色
     */
    ScrmResult<Boolean> bandUserRoleCheck(BandUserRoleParam param);

    /**
     * 批量获取员工角色明细
     */
    ScrmResult<List<UserRoleDetailDto>> getRolesByScWechatUserIds(List<Long> scWechatUserIds);


    /**
     * 编辑员工的管理部门
     */
    ScrmResult<Boolean> bandUserRoleDept(BandUserRoleDeptParam bandUserRoleDeptParam);
}
