package cn.com.duiba.scrm.center.api.dto.customer;

import cn.com.duiba.scrm.common.enums.wechat.DuibaTagEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.ExternalUserDetailResult;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 具有外部联系人功能企业员工也客户的关系表
 * 2021-7-23 15:36:33
 */
@Data
public class UserCustomerRelDto implements Serializable {

    /**
     * 主键id，自增
     */
    private Long id;

    /**
     * 添加了此外部联系人的企业成员:sc_user.id
     */
    private Long scUserId;

    /**
     * 客户id:sc_wechat_customer.id
     */
    private Long wechatCustomerId;

    /**
     * 客户外部联系人的userid
     */
    private String customerUserId;

    /**
     * 该成员对此外部联系人的备注
     */
    private String customerRemark;

    /**
     * 该成员对此外部联系人的描述
     */
    private String customerDescription;

    /**
     * 该成员对此客户备注的企业名称
     */
    private String remarkCorpName;

    /**
     * 该成员对此客户备注的手机号码
     */
    private String remarkMobiles;

    /**
     * 发起添加的userid，如果成员主动添加，为成员的userid；如果是客户主动添加，则为客户的外部联系人userid；如果是内部成员共享/管理员分配，则为对应的成员/管理员userid
     */
    private String operUserid;

    /**
     * 该成员添加此客户的来源
     */
    private Integer addWay;

    /**
     * 企业自定义的state参数，用于区分客户具体是通过哪个「联系我」添加，由企业通过创建「联系我」方式指定
     */
    private String linkState;

    /**
     * 状态（0删除，1正常，2:主动流失 3:被动流失）
     */
    private Integer relStatus;

    /**
     * 流失时间
     */
    private Date leaveTime;

    /**
     * 客户被动流失时间
     */
    private Date customerLeaveTime;

    /**
     * 企业id
     */
    private Long scCorpId;

    /**
     * 该成员添加此外部联系人的时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public static UserCustomerRelDto convert(ExternalUserDetailResult.FollowUser followUser) {
        UserCustomerRelDto userCustomerRelDto = new UserCustomerRelDto();
        userCustomerRelDto.setAddWay(followUser.getAddWay());
        userCustomerRelDto.setCustomerDescription(followUser.getDescription());
        userCustomerRelDto.setCustomerRemark(followUser.getRemark());
        userCustomerRelDto.setRemarkMobiles(JSON.toJSONString(followUser.getRemarkMobiles()));
        userCustomerRelDto.setOperUserid(followUser.getOperUserid());
        userCustomerRelDto.setRemarkCorpName(followUser.getRemarkCorpName());
        String state = followUser.getState();

        if (StringUtils.isNotBlank(state) && state.startsWith(DuibaTagEnum.DUIBA.getTag())) {
            userCustomerRelDto.setLinkState(state);
        } else {
            userCustomerRelDto.setLinkState("other");
        }
        userCustomerRelDto.setGmtCreate(new Date(followUser.getCreatetime() * 1000));
        return userCustomerRelDto;

    }

    public static UserCustomerRelDto convert(ExternalUserDetailResult.FollowInfo followInfo) {
        UserCustomerRelDto userCustomerRelDto = new UserCustomerRelDto();
        userCustomerRelDto.setAddWay(followInfo.getAdd_way());
        userCustomerRelDto.setCustomerDescription(followInfo.getDescription());
        userCustomerRelDto.setCustomerRemark(followInfo.getRemark());
        userCustomerRelDto.setRemarkMobiles(JSON.toJSONString(followInfo.getRemark_mobiles()));
        userCustomerRelDto.setOperUserid(followInfo.getOper_userid());
        userCustomerRelDto.setRemarkCorpName(followInfo.getRemark_company());
        String state = followInfo.getState();
        if (StringUtils.isNotBlank(state) && state.startsWith(DuibaTagEnum.DUIBA.getTag())) {
            userCustomerRelDto.setLinkState(state);
        } else {
            userCustomerRelDto.setLinkState("other");
        }
        userCustomerRelDto.setGmtCreate(new Date(followInfo.getCreatetime() * 1000));
        return userCustomerRelDto;
    }


}

