package cn.com.duiba.scrm.center.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.corp.ScCorpAccountDto;
import cn.com.duiba.scrm.center.api.param.corp.QueryCorpPageParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
* 企业信息配置表 RemoteService
* @author xiaotian
* 2021-7-13 16:05:14
*/
@AdvancedFeignClient
public interface RemoteScCorpAccountService {
    /**
    * 新增记录
    */
	Boolean save(ScCorpAccountDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(ScCorpAccountDto dto);
    /**
    * 根据id获取
    */
    ScCorpAccountDto getById(Long id);


    /**
     * 筛选列表
     * @param queryPageParam
     * @return
     */
    ScrmResult<List<ScCorpAccountDto>> querypageList(QueryCorpPageParam queryPageParam);

    ScrmResult<Integer> countQuerypageList(QueryCorpPageParam queryPageParam);
    /**
     * 根据
     * @param corpId
     * @return
     */
    ScCorpAccountDto getByCorpId(String corpId);
}
