package cn.com.duiba.stock.service.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/5/16.
 */
@AdvancedFeignClient
public interface RemoteStockService {

    /**
     * 查询库存数量<br/>
     * 接口有缓存
     *
     * @param stockId 库存ID
     * @return 库存数量
     */
    DubboResult<Long> find(long stockId);

    /**
     * 查询库存DTO<br/>
     * 接口有缓存
     *
     * @param stockId 库存ID
     * @return 库存DTO
     */
    DubboResult<StockDto> findDto(long stockId);

    /**
     * 批量查询库存数量<br/>
     * 接口有缓存3秒
     *
     * @param stockIds 库存ID集合 ,最大只允许1000个
     * @return 集合 key :库存ID value : 库存量
     */
    DubboResult<Map<Long, Long>> findBatch(List<Long> stockIds);

	/**
	 * 批量查询库存DTO<br/>
	 * 接口有缓存3秒
	 *
	 * @param stockIds 库存ID集合
	 * @return 集合 key :库存ID value : 库存量
	 * @return
	 */
	DubboResult<List<StockDto>> findBatchByIds(List<Long> stockIds);

    /**
     *
     * 消费减库存<br/>
     *
     * @author xuhengfei
     * @param consumeStockType @see ConsumeStockTypes
     * @param reqBiz 业务订单号
     * @param stockIds 需要减的库存id列表,可以为1个或者多个
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> consumeStock(int consumeStockType,String reqBiz,List<Long> stockIds);
    /**
     *
     * 失败回滚库存 <br/>
     *
     * @author xuhengfei
     * @param consumeStockType @see ConsumeStockTypes
     * @param reqBiz 业务订单号
     * @return 是否成功
     * @since JDK 1.6
     */
    DubboResult<Boolean> rollbackStock(int consumeStockType,String reqBiz);

    /**
     * 扣一个库存
     * @param consumeStockType 扣库存业务类型
     * @param reqBiz 业务订单号
     * @param stockId 库存ID
     * @return 是否成功
     */
    DubboResult<Boolean> consumeStockOne(int consumeStockType, String reqBiz, Long stockId);

    /**
     * 回滚库存
     * @param stockId 库存ID
     * @param consumeStockType 扣库存业务类型
     * @param reqBiz 业务订单号
     * @return 是否成功
     */
    DubboResult<Boolean> rollbackStockOne(Integer consumeStockType, String reqBiz, Long stockId);


    /**
     * 回滚定数量库存
     * @param stockId 库存ID
     * @param consumeStockType 扣库存业务类型
     * @param reqBiz 业务订单号
     * @param num  扣多少库存
     * @return 是否成功
     */
    DubboResult<Boolean> rollbackStockNum(Integer consumeStockType, String reqBiz, Long stockId, int num);

    /**
     * 扣指定数量的库存
     * @param consumeStockType 业务类型
     * @param reqBiz  业务流水号
     * @param stockId   库存ID
     * @param num  扣多少库存
     * @return true:成功   false:失败
     */
    DubboResult<Boolean> consumeStockNum(int consumeStockType, String reqBiz, Long stockId, int num);
    
}
