package cn.com.duiba.stock.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.stock.service.api.dto.StockSimpleDto;

import java.util.List;

/**
 * 央视频本地化定制专用remote
 */
@AdvancedFeignClient
public interface RemoteYspLocalStockService {
    /**
     * 查询商品库存(非主键id)
     */
    List<StockSimpleDto> findStockByStockIds(List<Long> stockIds);

    /**
     * 保存或更新库存信息
     *
     */
    void saveOrUpdateStock(StockSimpleDto dto);

    /**
     * 更新库存信息
     *
     * @param stockList
     */
    void updateStock(List<StockSimpleDto> stockList);
}
