package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.supplier.center.api.request.PurchaseRequestBase;
import cn.com.duiba.supplier.center.api.request.purchase.ObjectPurchaseRequest;
import cn.com.duiba.supplier.center.api.response.CancelOrderResponse;
import cn.com.duiba.supplier.center.api.response.ConfirmOrderResponse;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;
import cn.com.duiba.supplier.center.api.response.ReceivedOrderResponse;

/**
 * Created by hww on 2018/11/28 11:58 AM.
 */
@AdvancedFeignClient
public interface RemoteSupplyOrdersService {

    /**
     * 下采购单接口,预占库存
     * 构建对应的下单请求类进行下单
     *
     * @see ObjectPurchaseRequest 实物
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="10000")
    PurchaseOrderResponse purchaseOrder(PurchaseRequestBase request);

    /**
     * 确认预占采购单
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="6000")
    ConfirmOrderResponse confirmOrder(Long supplyOrderNum);

    /**
     * 取消预占采购单
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="6000")
    CancelOrderResponse cancelOrder(Long supplyOrderNum, String cancelReason);

    /**
     * 确认收货
     */
    ReceivedOrderResponse confirmReceived(Long supplyOrderNum);

//    List<ItemPushMsgResult> retrievePushMessage(Integer type);
//
//    List<Long> retrievePushMessageIds(Integer type);
//
//    void delPushMessageIds(String messageIds);
}
