package cn.com.duiba.supplier.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 供应商后台订单查询列表分页参数(是否已发完)的枚举
 * @author guoyanfei
 */
@AllArgsConstructor
@Getter
public enum SupplyOrderDeliveryStatusEnum {

    INCOMPLETE(1, "未发完"),
    COMPLETED(0, "已发完"),

    ;

    private final int    code;
    private final String desc;

    public static SupplyOrderDeliveryStatusEnum getByCode(int code) {
        for (SupplyOrderDeliveryStatusEnum value : values()) {
            if (value.code == code) {
                return value;
            }
        }
        throw new IllegalArgumentException("SupplyOrderDeliveryStatusEnum code:" + code + " not exist");
    }

    public static SupplyOrderDeliveryStatusEnum getByBoolean(boolean fullyDelivered) {
        return fullyDelivered ? COMPLETED : INCOMPLETE;
    }
}