package cn.com.duiba.supplier.channel.service.api.dto.request.bawangchaji;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;

import lombok.Data;

/**
 * 企迈-霸王直冲发放响应结果
 * @author yanggyukagn
 * @date 2024/1/24 1:36 PM
 */
@Data
public class QiMaiBaWangChaJiReq implements Serializable {

    private static final long serialVersionUID = -4429821352256408204L;

    /**
     * 商户id
     */
    @NotBlank(message = "商户id不能为空")
    private String mchId;

    /**
     * 充值号码
     */
    @NotBlank(message = "充值账号不能为空")
    private String mobilePhone;

    /**
     * 活动id
     */
    @NotBlank(message = "活动id不能为空")
    private String activityId;

    /**
     * 渠道id
     */
    @NotBlank(message = "渠道id不能为空")
    private String channelId;

    /**
     * 渠道账户id
     * 后面再改 目前不使用
     */
    private String channelAccountId;

    /**
     * 实付金额(单位:元)
     */
    private String actualPrice;

    /**
     * 订单总金额(单位:元)
     */
    private String totalAmount;
}
