package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jetbrains.annotations.NotNull;

/**
 * @author xuzhigang
 * @date 2024/12/10 10:56
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ExecuteApprovalTaskRequest extends BaseRequest {
    private static final long serialVersionUID = -3277917074291015521L;

    /**
     * 操作人userId
     */
    @NotNull
    private String actionerUserId;

    /**
     * 审批实例ID。
     */
    @NotNull
    private String processInstanceId;

    /**
     * 审批意见 可为空
     */
    private String remark;

    /**
     * 审批操作，取值
     * agree: 同意
     * refuse: 拒绝
     * @see cn.com.duiba.supplier.channel.service.api.enums.dingtalk.BpmsInstanceResultEnum
     */
    @NotNull
    private String result;

    /**
     * 任务id
     */
    @NotNull
    private Long taskId;
}
