package cn.com.duiba.supplier.channel.service.api.remoteservice.unionpay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.response.unionpay.UnionPayMachConfDto;
import cn.com.duiba.supplier.channel.service.api.param.unionpay.UnionPayMachConfSearchParam;
import java.util.List;

/**
 * 银联渠道配置表
 * @author kjj mybatis generator 
 * @date 2025-04-23
 */
@AdvancedFeignClient
public interface RemoteUnionPayMachConfService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 银联渠道配置集合
     */
    List<UnionPayMachConfDto> selectPage(UnionPayMachConfSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UnionPayMachConfSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银联渠道配置
     */
    UnionPayMachConfDto selectById(Long id);

    /**
     * 新增
     * @param dto 银联渠道配置
     * @return 执行结果
     */
    int insert(UnionPayMachConfDto dto);

    /**
     * 更新
     * @param dto 银联渠道配置
     * @return 影响行数
     */
    int update(UnionPayMachConfDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}