package cn.com.duiba.supplier.channel.service.api.dto.dingtalk.callback;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 审批任务变更信息
 *
 * @author xuzhigang
 * @date 2024/10/21 14:15
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BpmsTaskChangeDto extends BpmsEventEventCallbackBaseDto {
    private static final long serialVersionUID = 4463435570347212943L;

    /**
     * 创建任务的时间。时间戳，单位毫秒。
     */
    private Long createTime;

    /**
     * 结束任务的时间。时间戳，单位毫秒。
     */
    private Long finishTime;

    /**
     * 任务状态变更类型：
     * start：审批任务开始
     * finish：审批任务正常结束（完成或转交）
     * cancel：说明当前节点有多个审批人并且是或签，其中一个人执行了审批，其他审批人会推送cancel类型事件
     * comment：审批任务评论。
     */
    private String type;

    /**
     * 业务分类标识。
     */
    private String bizCategoryId;

    /**
     * 流程实例业务标识
     */
    private String businessId;

    /**
     * 审批结果：
     * agree：同意
     * refuse：拒绝
     * redirect：表示审批任务转交
     * audit：表示当前节点为办理人节点，audit为办理结果
     */
    private String result;

    /**
     * 用户userId：
     * 当前任务的审批人userId
     * 操作转交动作的用户userId
     */
    private String staffId;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 操作时写的评论内容。
     */
    private String remark;
}
