package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/5/6 15:56
 **/
@Data
public class WxFavorQueryUserCouponsDataResultDto implements Serializable {
    private static final long serialVersionUID = 4255006370927629829L;

    /**
     * 代金券id
     * 说明：微信为代金券唯一分配的id。
     * 必填，string(20)
     */
    private String couponId;

    /**
     * 创建批次的商户号
     * 说明：批次创建方商户号。
     * 必填，string(20)
     */
    private String stockCreatorMchId;

    /**
     * 批次号
     * 说明：微信为每个代金券批次分配的唯一id。
     * 必填，string(20)
     */
    private String stockId;

    /**
     * 代金券名称
     * 说明：代金券名称。
     * 必填，string(20)
     */
    private String couponName;

    /**
     * 代金券状态
     * 说明：代金券状态： SENDED：可用, USED：已实扣, EXPIRED：已过期
     * 必填，string(16)
     */
    private String status;

    /**
     * 使用说明
     * 说明：代金券描述说明字段。
     * 必填，string(3000)
     */
    private String description;

    /**
     * 领券时间
     * 说明：领券时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 必填，string(32)
     */
    private String createTime;

    /**
     * 券类型
     * 说明：券类型：NORMAL：满减券, CUT_TO：减至券
     * 必填，string(16)
     */
    private String couponType;

    /**
     * 是否无资金流
     * 说明：枚举值：true：是, false：否
     * 必填
     */
    private Boolean noCash;

    /**
     * 可用开始时间
     * 说明：可用开始时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 必填，string(32)
     */
    private String availableBeginTime;

    /**
     * 可用结束时间
     * 说明：可用结束时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 必填，string(32)
     */
    private String availableEndTime;

    /**
     * 是否单品优惠
     * 说明：枚举值：true：是, false：否
     * 必填
     */
     private Boolean singleItem;

    /**
     * out_request_no 　选填 string
     * 【商户单据号】商户此次发放凭据号
     */
    private String outRequestNo;

    /**
     * available_balance 　选填 integer
     * 【剩余金额】可用余额，单位：分。
     * 仅有当business_type=MULTIUSE时，才会返回。
     */
    private Integer availableBalance;

    /**
     * business_type 　选填 string
     * 【业务类型】细分业务类型，仅当business_type=MULTIUSE时才返回，枚举值：
     * MULTIUSE：消费金
     * 可选取值：
     * MULTIUSE: 消费金类型
     */
    private String businessType;

    /**
     * 单品优惠特定信息
     * 说明：单品优惠特定信息。
     * 非必填
     */
    private WxFavorUserCouponsCutToMessageResultDto cutToMessage;

    /**
     * 满减券信息
     * 说明：普通满减券面额、门槛信息。
     * 非必填
     */
    private WxFavorUserCouponsInformationResultDto normalCouponInformation;
}
