package cn.com.duiba.supplier.channel.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.conf.DouyinMchBalanceDto;
import cn.com.duiba.supplier.channel.service.api.param.conf.DouyinMchSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 抖音商户配置
 */
@AdvancedFeignClient
public interface RemoteDouYinpayMchConfService {

    /**
     * 查询所有的商户名称
     *
     * @return key：mchId，value：商户名称
     */
    Map<String, String> selectAllMchNameMap();

    /**
     * 查询所有商户余额
     *
     * @return
     */
    List<DouyinMchBalanceDto> selectAllBalance();

    /**
     * 更新余额
     */
    int updateBalance(DouyinMchBalanceDto dto);

    /**
     * 搜索
     *
     * @param param
     * @return
     */
    List<DouyinMchBalanceDto> search(DouyinMchSearchParam param);

    /**
     * 统计
     *
     * @param param
     * @return
     */
    Integer count(DouyinMchSearchParam param);

    /**
     * 更新余额告警配置
     *
     * @param dto
     * @return
     */
    Integer updateWarn(DouyinMchBalanceDto dto);
}
