package cn.com.duiba.supplier.channel.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.*;
import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.*;

/**
 * 钉钉审批流表
 * @author kjj mybatis generator 
 * @date 2024-10-19
 */
@AdvancedFeignClient
public interface RemoteDingTalkApprovalProcessService {

    /**
     * 发起审批
     *
     * @param request 请求参数
     * @return 审批实例id
     */
    StartApprovalProcessResponse startApprovalProcess(StartApprovalProcessRequest request);

    /**
     * 获取单个审批详情
     *
     * @param request 请求参数
     * @return 响应结果
     */
    GetApprovalDetailResponse getApprovalDetail(GetApprovalDetailRequest request);

    /**
     * 获取审批附件
     *
     * @param request 请求参数
     * @return 文件oss地址 长期有效
     */
    String getApprovalFile(GetApprovalFileRequest request);

    /**
     * 获取审批单流程中的节点信息
     * @param request 请求参数
     * @return 响应结果
     */
    GetApprovalProcessForecastResponse getApprovalProcessForecast(GetApprovalProcessForecastRequest request);

    /**
     * 获取审批表单
     *
     * @param request 请求参数
     * @return 响应结果 json字符串
     */
    GetApprovalSchemaResponse getApprovalSchema(GetApprovalSchemaRequest request);

    /**
     * 同意或拒绝审批任务
     *
     * @param request 请求参数
     * @return 执行审批操作返回参数
     */
    ExecuteApprovalTaskResponse executeApprovalTask(ExecuteApprovalTaskRequest request);

    /**
     * 添加审批实例的审批意见
     *
     * @param request 请求参数
     * @return 响应结果
     */
    AddApprovalCommentResponse addProcessInstanceComment(AddApprovalCommentRequest request);

    /**
     * 终止审批实例
     *
     * @param request 请求参数
     * @return 响应结果
     */
    TerminateApprovalInstanceResponse terminateApprovalInstance(TerminateApprovalInstanceRequest request);

    /**
     * 上传ossUrl到钉盘空间
     *
     * @param req 请求参数
     * @return 响应结果
     */
    CommitFileResp commitFileByOssUrl(CommitFileByOssUrlReq req);
}