package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk.ApprovalProcessForecastWorkFlowActivityRule;
import cn.com.duiba.supplier.channel.service.api.enums.dingtalk.CcPositionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/10/19 10:53
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class StartApprovalProcessRequest extends BaseRequest {
    private static final long serialVersionUID = -722708021743967905L;

    /**
     * 审批发起人的userId。
     */
    @NotBlank
    private String originatorUserId;

    /**
     * 审批流的唯一码。
     * process_code在审批模板编辑页面的URL中获取。
     */
    @NotBlank
    private String processCode;

    /**
     * 审批发起人所在的部门ID。
     */
    @NotBlank
    private Long deptId;

    /**
     * 审批实例变更 回调通知topic
     */
    private String instanceChangeTopic;

    /**
     * 审批实例变更 回调通知tag
     */
    private String instanceChangeTag;

    /**
     * 任务状态变更 回调通知topic
     */
    private String taskChangeTopic;

    /**
     * 任务状态变更 回调通知tag
     */
    private String taskChangeTag;

    /**
     * 使用审批流模板时，流程预测结果中节点规则上必填的自选操作人列表，最大列表长度：20。
     */
    private List<ApprovalTargetSelectActioner> targetSelectActioners;

    /**
     * 表单数据内容，控件列表，最大列表长度：150。
     */
    private List<ApprovalFormComponentValue> formComponentValues;

    /**
     * 工作流节点信息
     */
    private List<ApprovalProcessForecastWorkFlowActivityRule> workFlowActivityRules;

    /**
     * 不使用审批流模板时，直接指定的审批人列表，最大列表长度：20。
     * 说明
     * 指定审批单的执行流程，会覆盖审批单在OA后台设置的默认流程。
     */
    private List<StartProcessProcessApprover> approvers;

    /**
     * 抄送人列表 （使用approvers才生效）
     */
    private List<String> ccList;

    /**
     * 抄送时间点，取值：默认值：FINISH （使用approvers才生效）
     * START：开始时抄送
     * FINISH：结束时抄送
     * START_FINISH：开始和结束时都抄送
     */
    private String ccPosition;
}
