package cn.com.duiba.supplier.channel.service.api.dto.dingtalk;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 钉钉用户表
 * @author mybatis generator 
 * @date 2024-10-19
 */
@Data
public class DingTalkUserDto implements Serializable {
     
    private static final long serialVersionUID = 17293023599757575L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 员工的userId
     */
    private String userId;

    /**
     * 所属部门id列表
     */
    private List<Long> deptIdList;

    /**
     * 每个企业拥有唯一的CorpId
     */
    private String corpId;

    /**
     * 父部门链路列表，可能有多个父部门链路
     * [
     *  [1,2,3],
     *  [4,5,6]
     * ]
     */
    private List<List<Long>> parentDeptIdsList;

    /**
     * 员工的unionId
     */
    private String unionId;
}