package cn.com.duiba.supplier.channel.service.api.dto.response.shilitiaoyuan;

import java.io.Serializable;

import lombok.Data;

/**
 * 视里陶源支付宝红包响应
 *
 * @author yangyukang
 * @since 2025/1/14
 */
@Data
public class ShiLiTaoYuanAlipayRedPacketResp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 返回码，1代表成功
     */
    private Integer code;

    /**
     * 返回信息
     */
    private String msg;

    /**
     * 订单详情
     */
    private QueryOrderBody body;

    /**
     * 查询订单的订单详情
     */
    @Data
    public static class QueryOrderBody {
        /**
         * 商户订单号
         */
        private String outTradeId;

        /**
         * 订单号
         */
        private String orderNumber;

        /**
         * 自定义参数1
         */
        private String customerA;

        /**
         * 自定义参数2
         */
        private String customerB;

        /**
         * 订单状态
         * 0充值中 1成功 2失败 3退款中 4已退款 5退款失败
         */
        private String status;

        /**
         * 供应商备注
         */
        private String supplierRemark;
    }
} 