package cn.com.duiba.thirdpartyvnew.dto.wanda.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 万达优惠券详情DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaCouponDetail implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 券编码
     */
    private String code;
    
    /**
     * 券名称
     */
    private String name;
    
    /**
     * 券码
     */
    private String couponNo;
    
    /**
     * 领取时间
     */
    private Date receiveTime;
    
    /**
     * 券类型
     * 1定额券 2折扣券 3兑换券 4满减券
     */
    private String discountType;
    
    /**
     * 券有效期：开始时间
     */
    private Date beginDate;
    
    /**
     * 券有效期：结束时间
     */
    private Date endDate;
    
    /**
     * 券使用说明
     */
    private String description;
    
    /**
     * 使用门槛金额
     */
    private BigDecimal limitAmount;
    
    /**
     * 限制优惠金额
     */
    private BigDecimal discountLimitAmount;
    
    /**
     * 券状态
     * E未使用 C已使用 G已赠送 T已过期 V已作废 U赠送中
     */
    private String status;
    
    /**
     * 使用时间
     */
    private Date useTime;
    
    /**
     * 小程序appId
     */
    private String appId;
    
    /**
     * 小程序跳转url地址
     */
    private String skipUrl;
    
    /**
     * H5的url地址
     */
    private String h5Url;
    
    /**
     * 房价码
     */
    private String roomRateCode;
    
    /**
     * 是否支持手动核销
     * 当支持核销的时，需要判断有没有APPID和路径，
     * 如果没有的话就是直接调用核销接口核销，
     * 如果有路径就跳转到指定路径中去使用
     */
    private Boolean verificationFlag;
    
    /**
     * 判断是否可用
     * 
     * @return true: 可用(未使用), false: 不可用
     */
    public boolean isAvailable() {
        return "E".equals(status);
    }
    
    /**
     * 判断是否已使用
     * 
     * @return true: 已使用, false: 未使用
     */
    public boolean isUsed() {
        return "C".equals(status);
    }
    
    /**
     * 判断是否已过期
     * 
     * @return true: 已过期, false: 未过期
     */
    public boolean isExpired() {
        return "T".equals(status);
    }
    
    /**
     * 获取券状态描述
     * 
     * @return 状态描述
     */
    public String getStatusDescription() {
        if (status == null) {
            return "未知状态";
        }
        switch (status) {
            case "E":
                return "未使用";
            case "C":
                return "已使用";
            case "G":
                return "已赠送";
            case "T":
                return "已过期";
            case "V":
                return "已作废";
            case "U":
                return "赠送中";
            default:
                return "未知状态";
        }
    }
    
    /**
     * 获取券类型描述
     * 
     * @return 类型描述
     */
    public String getDiscountTypeDescription() {
        if (discountType == null) {
            return "未知类型";
        }
        switch (discountType) {
            case "1":
                return "定额券";
            case "2":
                return "折扣券";
            case "3":
                return "兑换券";
            case "4":
                return "满减券";
            default:
                return "未知类型";
        }
    }
} 