package cn.com.duiba.thirdpartyvnew.dto.jincheng;


import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqInterface;

import java.io.Serializable;
import java.util.List;

/**
 * 金城查询响应
 */
public class PurchaseCallbackRequest extends BaseResponseData implements BaseReqInterface,Serializable {
    /**
     * 下单结果-成功
     */
    public static final String SUCCESS = "SUCC";
    /**
     * 下单结果-处理中
     */
    public static final String PROCESSING = "PROCESSING";
    /**
     * 下单结果-失败
     */
    public static final String FAIL = "FAIL";

    /**
     * 商品类型-直冲
     */
    public static final Integer GOOD_TYPE_DIRECT_CHARGE = 1;
    /**
     * 商品类型-卡密
     */
    public static final Integer GOOD_TYPE_CARD = 2;
    /**
     * 商品类型-链接券
     */
    public static final Integer GOOD_TYPE_LINK = 3;
    /**
     * 订单号
     * 必须字段
     */
    private String linkOrderNo;

    /**
     * 订单兑换结果
     * 必须字段
     * SUCC：成功，PROCESSING：处理中，FAIL：失败
     */
    private String orderStatus;
    /**
     * 交付类型
     * 必须字段
     * 1：直充类
     * 2：卡密类
     * 3：链接类
     */
    private Integer deliveryType;

    /**
     * 直充类数据返回
     * 必须字段，List<JinchengDirectChargeData> 类型
     */
    private List<JinchengDirectChargeData> directChargeList;

    /**
     * 卡号信息
     * 必须字段，List<JinchengCardInfoData> 类型
     */
    private List<JinchengCardInfoData> cardInfoList;


    /**
     * 链接类数据信息
     * 必须字段，List<JinchengLinkInfoData> 类型
     */
    private List<JinchengLinkInfoData> linkInfoList;

    @Override
    public BaseReqDto getCommonParam() {
        return null;
    }

    public String getLinkOrderNo() {
        return linkOrderNo;
    }

    public void setLinkOrderNo(String linkOrderNo) {
        this.linkOrderNo = linkOrderNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public List<JinchengDirectChargeData> getDirectChargeList() {
        return directChargeList;
    }

    public void setDirectChargeList(List<JinchengDirectChargeData> directChargeList) {
        this.directChargeList = directChargeList;
    }

    public List<JinchengCardInfoData> getCardInfoList() {
        return cardInfoList;
    }

    public void setCardInfoList(List<JinchengCardInfoData> cardInfoList) {
        this.cardInfoList = cardInfoList;
    }

    public List<JinchengLinkInfoData> getLinkInfoList() {
        return linkInfoList;
    }

    public void setLinkInfoList(List<JinchengLinkInfoData> linkInfoList) {
        this.linkInfoList = linkInfoList;
    }
}
