package cn.com.duiba.thirdpartyvnew.dto.jinke.response;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.List;

/**
 * 金科资源列表查询响应
 *
 * @author system
 * @date 2024/12/19
 */
public class MerchantAssetsQueryResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 业务结果
     */
    private List<AssetInfo> list;

    /**
     * 页码
     */
    private Integer page;

    /**
     * 每页记录数
     */
    @JSONField(name = "page_size")
    private Integer pageSize;

    /**
     * 总数
     */
    private Integer total;

    public List<AssetInfo> getList() {
        return list;
    }

    public void setList(List<AssetInfo> list) {
        this.list = list;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    /**
     * 资源信息
     */
    public static class AssetInfo implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 总数量
         */
        @JSONField(name = "asign_num")
        private Integer asignNum;

        /**
         * 剩余数量
         */
        @JSONField(name = "rest_num")
        private Integer restNum;

        /**
         * 生效时间（时间戳）
         */
        @JSONField(name = "effective_time")
        private Long effectiveTime;

        /**
         * 失效时间（时间戳）
         */
        @JSONField(name = "failure_time")
        private Long failureTime;

        /**
         * 状态
         */
        private Integer status;

        /**
         * 资源编码
         */
        @JSONField(name = "asset_code")
        private String assetCode;

        /**
         * 资源类型：coupon优惠券；redpacket积分
         */
        @JSONField(name = "asset_category")
        private String assetCategory;

        public Integer getAsignNum() {
            return asignNum;
        }

        public void setAsignNum(Integer asignNum) {
            this.asignNum = asignNum;
        }

        public Integer getRestNum() {
            return restNum;
        }

        public void setRestNum(Integer restNum) {
            this.restNum = restNum;
        }

        public Long getEffectiveTime() {
            return effectiveTime;
        }

        public void setEffectiveTime(Long effectiveTime) {
            this.effectiveTime = effectiveTime;
        }

        public Long getFailureTime() {
            return failureTime;
        }

        public void setFailureTime(Long failureTime) {
            this.failureTime = failureTime;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getAssetCode() {
            return assetCode;
        }

        public void setAssetCode(String assetCode) {
            this.assetCode = assetCode;
        }

        public String getAssetCategory() {
            return assetCategory;
        }

        public void setAssetCategory(String assetCategory) {
            this.assetCategory = assetCategory;
        }
    }
}