package cn.com.duiba.thirdpartyvnew.dto.lshm.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = true)
public class LshmSendParticularCouponRequest extends LshmBaseRequest implements Serializable {
    public static final String BIZ_TYPE = "Dui_Ba";

    // 活动编号
    private String marketingCampaignId;

    // 会员编号
    private Long memberId;

    // 奖品编号
    private Long prizeId;

    // 发放类型
    //类型枚举如下（区分大小写）：
    //优惠券：coupon
    //订单：item
    //积分：point
    //礼品卡：giftCard
    private String prizeType;

    // 门店编号 (订单必填)
    private String storeId;

    // 过期时间（积分必填）
    private String expireDate;

    // 礼品卡单据号（礼品卡必填）
    private String taskNo;

    // 发放数量
    private Long sendQuantity;

    // 业务类型（DuiBa）
    private String bizType;

    // 业务编号
    private String bizNo;

    // 签名
    private String sign;

    // 时间戳（ms）
    private Long timestamp;

}
